function [peak1_indiv_cell_075_WT, peak2_indiv_cell_075_WT, peak2_extr_indiv_cell_075_WT, ppr_indiv_cell_exp, ppr_extr_indiv_cell_exp] = call_data_analysis_WT_OK(plot_on_off, show_plot_on_off)



if ~ (exist('./Exp_data', 'dir'))
    error('You are not in the appropriate folder')
end

folder_name = './Exp_data/WT_OK_data/data/'

cell_075_WT = {'0155', '0167', '0179', '0191', '0203', '0217'};
cell_075_OK = {'0003', '0027', '0039', '0066', '0078', '0104', '0119', '0131'}; 
cell_15_WT = {'0075', '0090', '0161', '0178', '0190'};
cell_15_OK = {'0047', '0059', '0114', '0126', '0138'}; 


num_sweeps = 1;
num_calc = 2;

% total_number = num_cells * num_sweeps * num_calc;

% start_numbers = [0 3 1 1 0 0];

peak1_indiv_cell_075_WT = zeros(length(cell_075_WT),1);
peak2_indiv_cell_075_WT = zeros(length(cell_075_WT),1);
peak2_extr_indiv_cell_075_WT = zeros(length(cell_075_WT),1);

peak1_indiv_cell_075_OK = zeros(length(cell_075_OK),1);
peak2_indiv_cell_075_OK = zeros(length(cell_075_OK),1);
peak2_extr_indiv_cell_075_OK = zeros(length(cell_075_OK),1);

peak1_indiv_cell_15_WT = zeros(length(cell_15_WT),1);
peak2_indiv_cell_15_WT = zeros(length(cell_15_WT),1);
peak2_extr_indiv_cell_15_WT = zeros(length(cell_15_WT),1);

peak1_indiv_cell_15_OK = zeros(length(cell_15_OK),1);
peak2_indiv_cell_15_OK = zeros(length(cell_15_OK),1);
peak2_extr_indiv_cell_15_OK = zeros(length(cell_15_OK),1);




% stim1_begins = zeros(num_calc, num_cells*num_sweeps);

exp_types = [repmat(1, 1, length(cell_075_WT)) ...
                repmat(2, 1, length(cell_075_OK)) ...
                repmat(3, 1, length(cell_15_WT)) ...
                repmat(4, 1, length(cell_15_OK))];

num_total = length(cell_075_WT) + length(cell_075_OK) + length(cell_15_WT) + length(cell_15_OK);
            
            

for k = 1:num_total

    type_num = exp_types(k);
    
    if k <= length(cell_075_WT)
        cell_num = k;
        cell_name = cell_075_WT{cell_num}
        filename = [folder_name '0_75mM/WT/2019_11_25_' cell_name '.abf']
    elseif k<= length(cell_075_WT) + length(cell_075_OK)
        cell_num = k-length(cell_075_WT);
        cell_name = cell_075_OK{cell_num}
        filename = [folder_name '0_75mM/OK6/2019_11_25_' cell_name '.abf']
        
    elseif k <= length(cell_075_WT) + length(cell_075_OK) + length(cell_15_WT)
        cell_num = k-length(cell_075_WT)-length(cell_075_OK);
        cell_name = cell_15_WT{cell_num}
        filename = [folder_name '1_5mM/WT/2019_11_26_' cell_name '.abf']
        
    elseif k <= num_total
        cell_num = k-length(cell_075_WT)-length(cell_075_OK)-length(cell_15_OK);
        cell_name = cell_15_OK{cell_num}
        filename = [folder_name '1_5mM/OK6/2019_11_26_' cell_name '.abf']
    end

    [peak1s, peak2s, peak2_extrs, time_vec, EPSCs_trans, stim1_begs] = data_analyze_abf_WT_OK(filename, k, plot_on_off, show_plot_on_off);
    
    
    
    
    
    if k <= length(cell_075_WT)
        peak1_indiv_cell_075_WT(cell_num) = peak1s;
        peak2_indiv_cell_075_WT(cell_num) = peak2s;
        peak2_extr_indiv_cell_075_WT(cell_num) = peak2_extrs;
    elseif k<= length(cell_075_WT) + length(cell_075_OK)        peak1_indiv_cell_075_OK(cell_num) = peak1s;
        peak2_indiv_cell_075_OK(cell_num) = peak2s;
        peak2_extr_indiv_cell_075_OK(cell_num) = peak2_extrs;
        
    elseif k <= length(cell_075_WT) + length(cell_075_OK) + length(cell_15_WT)
        peak1_indiv_cell_15_WT(cell_num) = peak1s;
        peak2_indiv_cell_15_WT(cell_num) = peak2s;
        peak2_extr_indiv_cell_15_WT(cell_num) = peak2_extrs;
    elseif k <= num_total
        peak1_indiv_cell_15_OK(cell_num) = peak1s;
        peak2_indiv_cell_15_OK(cell_num) = peak2s;
        peak2_extr_indiv_cell_15_OK(cell_num) = peak2_extrs;
    end
    

end


%%%%Test whether horisontal alignment is necessary
% test_stim = stim1_begins(:) - stim1_begins(1,1,1);
% test_stim_res = sum(test_stim);

% if test_stim_res~= 0
%     error('Operation terminated prematurely: EPSCs need horisontal alignment')    
% end
% 

ppr_indiv_075_WT = peak2_indiv_cell_075_WT ./ peak1_indiv_cell_075_WT;
ppr_indiv_075_OK = peak2_indiv_cell_075_OK ./ peak1_indiv_cell_075_OK;
ppr_indiv_15_WT = peak2_indiv_cell_15_WT ./ peak1_indiv_cell_15_WT;
ppr_indiv_15_OK = peak2_indiv_cell_15_OK ./ peak1_indiv_cell_15_OK;

ppr_extr_indiv_075_WT = peak2_extr_indiv_cell_075_WT ./ peak1_indiv_cell_075_WT;
ppr_extr_indiv_075_OK = peak2_extr_indiv_cell_075_OK ./ peak1_indiv_cell_075_OK;
ppr_extr_indiv_15_WT = peak2_extr_indiv_cell_15_WT ./ peak1_indiv_cell_15_WT;
ppr_extr_indiv_15_OK = peak2_extr_indiv_cell_15_OK ./ peak1_indiv_cell_15_OK;


save('./Exp_data/data_WT_OK.mat', 'peak1_indiv_cell_075_OK', 'peak1_indiv_cell_075_WT', 'peak1_indiv_cell_15_OK', 'peak1_indiv_cell_15_WT', 'peak2_indiv_cell_075_OK', 'peak2_indiv_cell_075_WT', 'peak2_indiv_cell_15_OK', 'peak2_indiv_cell_15_WT', 'peak2_extr_indiv_cell_075_OK', 'peak2_extr_indiv_cell_075_WT', 'peak2_extr_indiv_cell_15_OK', 'peak2_extr_indiv_cell_15_WT', 'ppr_indiv_075_WT', 'ppr_indiv_075_OK', 'ppr_indiv_15_WT', 'ppr_indiv_15_OK', 'ppr_extr_indiv_075_WT', 'ppr_extr_indiv_075_OK', 'ppr_extr_indiv_15_WT', 'ppr_extr_indiv_15_OK')